<?php
// توکن ربات خود را اینجا قرار دهید
$token = '8344561684:AAH61JYG6g8Kf-0jMAxrNwnKXI6Pv3rDafY';
$apiUrl = "https://api.telegram.org/bot{$token}/";

// --- تنظیمات نمایش خطا (مخصوص تست) ---
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// --- اتصال به دیتابیس ---
$servername = "localhost";
$username = "falnicsv_user";
$password = 'ye+7kmn0=zQp$Yt3'; // رمز عبور واقعی دیتابیس را وارد کنید
$dbname = "falnicsv_telegram"; // نام دیتابیس واقعی را وارد کنید

// ایجاد اتصال
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
  // در صورت بروز خطا، پیام خطا را نمایش داده و اسکریپت را متوقف کنید
  die("Connection failed: " . $conn->connect_error);
}
$conn->set_charset("utf8mb4");

// دریافت اطلاعات از تلگرام
$content = file_get_contents("php://input");
$update = json_decode($content, true);

if (!$update) {
  exit;
}

// استخراج اطلاعات اصلی
// $message = isset($update['message']) ? $update['message'] : "";
// $chat_id = isset($message['chat']['id']) ? $message['chat']['id'] : "";
// $text = isset($message['text']) ? $message['text'] : "";

// // --- مدیریت کاربر و وضعیت ---
// $stmt = $conn->prepare("INSERT IGNORE INTO users (id) VALUES (?)");
// $stmt->bind_param("s", $chat_id);
// $stmt->execute();
// $stmt->close();

// $state = '';
// $stmt = $conn->prepare("SELECT state FROM users WHERE id = ?");
// $stmt->bind_param("s", $chat_id);
// $stmt->execute();
// $result = $stmt->get_result();
// if ($result->num_rows > 0) {
//   $row = $result->fetch_assoc();
//   $state = $row['state'];
// }
// $stmt->close


// استخراج اطلاعات اصلی
$message = isset($update['message']) ? $update['message'] : "";
$chat_id = isset($message['chat']['id']) ? $message['chat']['id'] : "";
$text = isset($message['text']) ? $message['text'] : "";

// --- مدیریت کاربر و وضعیت ---
// کد جدید جایگزین شد:
$first_name = isset($message['chat']['first_name']) ? $message['chat']['first_name'] : "";
$username = isset($message['chat']['username']) ? $message['chat']['username'] : "";

$stmt = $conn->prepare("INSERT INTO users (id, first_name, username) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE first_name = VALUES(first_name), username = VALUES(username)");
$stmt->bind_param("sss", $chat_id, $first_name, $username);
$stmt->execute();
$stmt->close();
// پایان کد جدید

$state = '';
$stmt = $conn->prepare("SELECT state FROM users WHERE id = ?");
$stmt->bind_param("s", $chat_id);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows > 0) {
  $row = $result->fetch_assoc();
  $state = $row['state'];
}
$stmt->close();

// تابع برای به‌روزرسانی وضعیت کاربر
function updateUserState($chatId, $newState) {
  global $conn;
  $stmt = $conn->prepare("UPDATE users SET state = ? WHERE id = ?");
  $stmt->bind_param("ss", $newState, $chatId);
  $stmt->execute();
  $stmt->close();
}

// تابع برای بررسی ادمین بودن کاربر
function isAdmin($chatId) {
  global $conn;
  $stmt = $conn->prepare("SELECT is_admin FROM users WHERE id = ?");
  $stmt->bind_param("s", $chatId);
  $stmt->execute();
  $result = $stmt->get_result();
  if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    return $row['is_admin'] == 1;
  }
  return false;
}

// تابع اصلی برای ارسال پیام
function sendMessage($chatId, $text, $keyboard = null) {
  global $apiUrl;
  $data = [
    'chat_id' => $chatId,
    'text' => $text,
    'parse_mode' => 'HTML',
    'reply_markup' => $keyboard
  ];
  
  // استفاده از @ برای جلوگیری از نمایش خطا در صورت بلاک بودن کاربر
  $result = @file_get_contents($apiUrl . 'sendMessage?' . http_build_query($data));
  
  // اگر نتیجه برگردد یعنی موفق بوده، اگر false باشد یعنی ناموفق (بلاک شده یا خطا)
  return $result ? true : false;
}

// تابع برای ساخت دکمه‌های کیبورد
function buildKeyboard($buttons, $resize = true, $one_time = false) {
  $keyboard = ['keyboard' => $buttons, 'resize_keyboard' => $resize, 'one_time_keyboard' => $one_time];
  return json_encode($keyboard);
}

// --- پردازش دستورات و پیام‌ها (بخش کلیدی) ---
// ابتدا وضعیت کاربر را بررسی می کنیم
if (strpos($state, 'awaiting_lottery_') !== false) {
  $type = str_replace('awaiting_lottery_', '', $state);
  updateLotteryContent($chat_id, $type, $text);
} elseif (strpos($state, 'awaiting_seminar_') !== false) {
  $type = str_replace('awaiting_seminar_', '', $state);
  updateSeminarContent($chat_id, $type, $text);
} elseif ($state === 'awaiting_about_us') {
  updateStaticContent($chat_id, 'about_us', $text);
} elseif ($state === 'awaiting_contact_info') {
  updateStaticContent($chat_id, 'contact_info', $text);
} elseif ($state === 'awaiting_new_ticket_content') {
  updateNewTicketContent($chat_id, $text);
} elseif ($state === 'awaiting_service_faq_content') {
  updateServiceFAQContent($chat_id, $text);
}elseif ($state === 'awaiting_broadcast_message') { // <--- این شرط جدید است
  performBroadcast($chat_id, $text);
} else {
  // اگر کاربر در وضعیت خاصی نیست، دستورات را پردازش می کنیم
  switch ($text) {
    case '/start':
    case 'منوی اصلی':
      sendMainMenu($chat_id);
      break;
    case '/admin':
      if (isAdmin($chat_id)) {
        sendAdminMenu($chat_id);
      } else {
        sendMessage($chat_id, 'شما دسترسی ادمین ندارید.');
      }
      break;
    case 'مدیریت قرعه‌کشی‌ها':
      if (isAdmin($chat_id)) {
        sendLotteryAdminMenu($chat_id);
      }
      break;
    // --- شروع تغییرات ادمین رویدادها ---
    case 'مدیریت رویدادها': // تغییر نام
      if (isAdmin($chat_id)) {
        sendEventsAdminMenu($chat_id); // تابع جدید
      }
      break;
    // --- پایان تغییرات ادمین رویدادها ---
    case 'مدیریت پشتیبانی مشتریان':
      if (isAdmin($chat_id)) {
        sendTicketingAdminMenu($chat_id);
      }
      break;
    case 'ویرایش درباره فالنیک':
      if (isAdmin($chat_id)) {
        updateUserState($chat_id, 'awaiting_about_us');
        sendMessage($chat_id, 'لطفاً متن جدید بخش درباره فالنیک را وارد کنید.');
      }
      break;
    case 'ویرایش اطلاعات تماس':
      if (isAdmin($chat_id)) {
        updateUserState($chat_id, 'awaiting_contact_info');
        sendMessage($chat_id, 'لطفاً متن جدید بخش اطلاعات تماس را وارد کنید.');
      }
      break;
      // --- شروع کد جدید ---
    case '📢 ارسال پیام همگانی':
      if (isAdmin($chat_id)) {
        updateUserState($chat_id, 'awaiting_broadcast_message');
        sendMessage($chat_id, 'لطفاً پیامی که می‌خواهید برای تمام کاربران ارسال شود را وارد کنید. (متن، لینک و اموجی پشتیبانی می‌شود)', buildKeyboard([['منوی اصلی']]));
      }
      break;
      
      case '👥 دریافت لیست کاربران':
      if (isAdmin($chat_id)) {
        exportUsersList($chat_id);
      }
      break;
    // --- مدیریت ادمین قرعه‌کشی (بدون تغییر) ---
    case 'ویرایش قرعه‌کشی فعلی':
      if (isAdmin($chat_id)) {
        updateUserState($chat_id, 'awaiting_lottery_current_lottery_info');
        sendMessage($chat_id, 'لطفاً متن جدید قرعه‌کشی فعلی را وارد کنید.');
      }
      break;
    case 'ویرایش نحوه شرکت':
      if (isAdmin($chat_id)) {
        updateUserState($chat_id, 'awaiting_lottery_how_to_participate');
        sendMessage($chat_id, 'لطفاً متن جدید نحوه شرکت را وارد کنید.');
      }
      break;
    case 'ویرایش نتایج دوره قبل':
      if (isAdmin($chat_id)) {
        updateUserState($chat_id, 'awaiting_lottery_previous_lottery_results');
        sendMessage($chat_id, 'لطفاً متن جدید نتایج دوره قبل را وارد کنید.');
      }
      break;
    case 'ویرایش سوالات متداول قرعه‌کشی':
      if (isAdmin($chat_id)) {
        updateUserState($chat_id, 'awaiting_lottery_lottery_faq');
        sendMessage($chat_id, 'لطفاً متن جدید سوالات متداول قرعه‌کشی را وارد کنید.');
      }
      break;
    case 'ویرایش دعوت از دوستان':
      if (isAdmin($chat_id)) {
        updateUserState($chat_id, 'awaiting_lottery_invite_friends');
        sendMessage($chat_id, 'لطفاً متن جدید دعوت از دوستان را وارد کنید.');
      }
      break;
    // --- شروع کیس‌های ادمین برای رویدادها (جدید) ---
    case 'ویرایش لیست وبینارها و سرفصل ها':
      if (isAdmin($chat_id)) {
        updateUserState($chat_id, 'awaiting_seminar_nextnode_webinars');
        sendMessage($chat_id, 'لطفاً متن جدید "لیست وبینارها و سرفصل ها" را وارد کنید.');
      }
      break;
    case 'ویرایش لیست اساتید':
      if (isAdmin($chat_id)) {
        updateUserState($chat_id, 'awaiting_seminar_nextnode_instructors');
        sendMessage($chat_id, 'لطفاً متن جدید "لیست اساتید" را وارد کنید.');
      }
      break;
    case 'ویرایش اخبار رویداد':
      if (isAdmin($chat_id)) {
        updateUserState($chat_id, 'awaiting_seminar_nextnode_news');
        sendMessage($chat_id, 'لطفاً متن جدید "اخبار رویداد" را وارد کنید.');
      }
      break;
    case 'ویرایش لینک دعوت':
      if (isAdmin($chat_id)) {
        updateUserState($chat_id, 'awaiting_seminar_nextnode_invite_link');
        sendMessage($chat_id, 'لطفاً متن جدید "لینک دعوت برای ثبت نام رویداد" را وارد کنید.');
      }
      break;
    case 'ویرایش آرشیو حضوری':
      if (isAdmin($chat_id)) {
        updateUserState($chat_id, 'awaiting_seminar_archive_in_person');
        sendMessage($chat_id, 'لطفاً متن جدید "رویدادهای حضوری" را وارد کنید.');
      }
      break;
    case 'ویرایش آرشیو آنلاین':
      if (isAdmin($chat_id)) {
        updateUserState($chat_id, 'awaiting_seminar_archive_online');
        sendMessage($chat_id, 'لطفاً متن جدید "رویدادهای آنلاین" را وارد کنید.');
      }
      break;
    // --- پایان کیس‌های ادمین برای رویدادها ---
    
    // --- مدیریت ادمین پشتیبانی (بدون تغییر) ---
    case 'ویرایش ثبت تیکت جدید':
      if (isAdmin($chat_id)) {
        updateUserState($chat_id, 'awaiting_new_ticket_content');
        sendMessage($chat_id, 'لطفاً متن جدید برای بخش ثبت تیکت جدید را وارد کنید.');
      }
      break;
    case 'ویرایش سوالات متداول':
      if (isAdmin($chat_id)) {
        updateUserState($chat_id, 'awaiting_service_faq_content');
        sendMessage($chat_id, 'لطفاً متن جدید برای بخش سوالات متداول را وارد کنید.');
      }
      break;
    
    // --- منوهای اصلی کاربر ---
    case '🎁 قرعه‌کشی‌ها':
      sendGiveawaysMenu($chat_id);
      break;
    case '🎓 رویدادهای فالنیک': 
      sendEventsMenu($chat_id); 
      break;
    case '💬 چت مستقیم با کارشناسان':
            $inlineKeyboard = json_encode([
                'inline_keyboard' => [
                    [
                        ['text' => '🔗 ورود به گفتگوی آنلاین', 'url' => 'http://zaya.link/gof']
                    ]
                ]
            ]);
            sendMessage($chat_id, 'برای ارتباط مستقیم با کارشناسان فالنیک، روی دکمه زیر کلیک کنید:', $inlineKeyboard);
      break;
    case 'ℹ️ درباره فالنیک':
      sendAboutUs($chat_id);
      break;
    case '📞 اطلاعات تماس':
      sendContactInfo($chat_id);
      break;
    case '🎫 پشتیبانی مشتریان':
      sendTicketingMenu($chat_id);
      break;
    
    // --- دکمه‌های قرعه‌کشی (بدون تغییر) ---
    case '📣 قرعه‌کشی فعلی':
      sendLotteryContent($chat_id, 'current_lottery_info');
      break;
    case '📝 نحوه شرکت':
      sendLotteryContent($chat_id, 'how_to_participate');
      break;
    case '🏆 نتایج دوره قبل':
      sendLotteryContent($chat_id, 'previous_lottery_results');
      break;
    case '❓ سوالات متداول قرعه‌کشی':
      sendLotteryContent($chat_id, 'lottery_faq');
      break;
    case '📤 دعوت از دوستان':
      sendLotteryContent($chat_id, 'invite_friends');
      break;
    
    // --- دکمه‌های منوی رویدادها (جدید) ---
    case 'رویداد Nextnode-sijourney':
      sendNextnodeMenu($chat_id);
      break;
    case 'آرشیو رویدادها':
      sendArchiveMenu($chat_id);
      break;
    case 'لیست وبینارها و سرفصل ها':
      sendSeminarContent($chat_id, 'nextnode_webinars');
      break;
    case 'لیست اساتید':
      sendSeminarContent($chat_id, 'nextnode_instructors');
      break;
    case 'اخبار رویداد':
      sendSeminarContent($chat_id, 'nextnode_news');
      break;
    case 'لینک دعوت برای ثبت نام رویداد':
      sendSeminarContent($chat_id, 'nextnode_invite_link');
      break;
    case 'رویدادهای حضوری':
      sendSeminarContent($chat_id, 'archive_in_person');
      break;
    case 'رویدادهای آنلاین':
      sendSeminarContent($chat_id, 'archive_online');
      break;
    
    // --- دکمه‌های پشتیبانی (بدون تغییر) ---
    case '📝 ثبت تیکت جدید':
      sendNewTicketInfo($chat_id);
      break;
    case '❓ سوالات متداول':
      sendServiceFAQ($chat_id);
      break;
    
    // --- دکمه‌های حذف شده ---
    case '📂 مشاهده تیکت‌های قبلی':
    case '🛠 راهنمای رفع مشکل سریع':
      sendMessage($chat_id, 'این گزینه دیگر در دسترس نیست.');
      break;
    default:
      sendMessage($chat_id, 'گزینه مورد نظر خود را از منو انتخاب کنید.');
      break;
  }
}

// --- توابع مربوط به ادمین ---

function sendAdminMenu($chatId) {
  $keyboard = buildKeyboard([
['📢 ارسال پیام همگانی', '👥 دریافت لیست کاربران'], // دکمه جدید اضافه شد    ['مدیریت قرعه‌کشی‌ها'],
    ['مدیریت رویدادها'], // تغییر نام
    ['مدیریت پشتیبانی مشتریان'],
    ['ویرایش درباره فالنیک'],
    ['ویرایش اطلاعات تماس'],
    ['منوی اصلی']
  ]);
  sendMessage($chatId, 'به پنل ادمین خوش آمدید. لطفاً گزینه مورد نظر خود را انتخاب کنید.', $keyboard);
}

function sendLotteryAdminMenu($chatId) {
  $keyboard = buildKeyboard([
    ['ویرایش قرعه‌کشی فعلی'],
    ['ویرایش نحوه شرکت'],
    ['ویرایش نتایج دوره قبل'],
    ['ویرایش سوالات متداول قرعه‌کشی'],
    ['ویرایش دعوت از دوستان'],
    ['منوی اصلی']
  ]);
  sendMessage($chatId, 'لطفاً گزینه‌ای برای ویرایش محتوای قرعه‌کشی انتخاب کنید.', $keyboard);
}

// --- تابع منوی ادمین سمینار (تغییر یافته) ---
function sendEventsAdminMenu($chatId) {
  $keyboard = buildKeyboard([
    ['ویرایش لیست وبینارها و سرفصل ها'],
    ['ویرایش لیست اساتید'],
    ['ویرایش اخبار رویداد'],
    ['ویرایش لینک دعوت'],
    ['ویرایش آرشیو حضوری'],
    ['ویرایش آرشیو آنلاین'],
    ['منوی اصلی']
  ]);
  sendMessage($chatId, 'لطفاً گزینه‌ای برای ویرایش محتوای رویدادها انتخاب کنید.', $keyboard);
}

// تابع جدید برای منوی مدیریت تیکتینگ
function sendTicketingAdminMenu($chatId) {
  $keyboard = buildKeyboard([
    ['ویرایش ثبت تیکت جدید'],
    ['ویرایش سوالات متداول'],
    ['منوی اصلی']
  ]);
  sendMessage($chatId, 'لطفاً گزینه‌ای برای ویرایش محتوای پشتیبانی مشتریان انتخاب کنید.', $keyboard);
}

// --- توابع به‌روزرسانی ---
function updateLotteryContent($chatId, $type, $content) {
  global $conn;
  $stmt = $conn->prepare("INSERT INTO lotteries (type, content, admin_id) VALUES (?, ?, ?)");
  $stmt->bind_param("sss", $type, $content, $chatId);
  $stmt->execute();
  $stmt->close();
  updateUserState($chatId, null);
  sendMessage($chatId, 'محتوای قرعه‌کشی با موفقیت ذخیره شد.');
  sendLotteryAdminMenu($chatId);
}

function updateSeminarContent($chatId, $type, $content) {
  global $conn;
  $stmt = $conn->prepare("INSERT INTO seminars (type, content) VALUES (?, ?)");
  $stmt->bind_param("ss", $type, $content);
  $stmt->execute();
  $stmt->close();
  updateUserState($chatId, null);
  sendMessage($chatId, 'محتوای سمینار با موفقیت ذخیره شد.');
  sendEventsAdminMenu($chatId); // بازگشت به منوی ادمین رویدادها
}

function updateStaticContent($chatId, $type, $content) {
  global $conn;
  $stmt = $conn->prepare("INSERT INTO static_contents (type, content, admin_id) VALUES (?, ?, ?)");
  $stmt->bind_param("sss", $type, $content, $chatId);
  $stmt->execute();
  $stmt->close();
  updateUserState($chatId, null);
  sendMessage($chatId, 'محتوای با موفقیت ذخیره شد.');
  sendAdminMenu($chatId);
}

function updateNewTicketContent($chatId, $content) {
  global $conn;
  $stmt = $conn->prepare("INSERT INTO static_contents (type, content, admin_id) VALUES (?, ?, ?)");
  $type = 'new_ticket_info';
  $stmt->bind_param("sss", $type, $content, $chatId);
  $stmt->execute();
  $stmt->close();
  updateUserState($chatId, null);
  sendMessage($chatId, 'محتوای بخش ثبت تیکت جدید با موفقیت ذخیره شد.');
  sendTicketingAdminMenu($chatId);
}

function updateServiceFAQContent($chatId, $content) {
  global $conn;
  $stmt = $conn->prepare("INSERT INTO static_contents (type, content, admin_id) VALUES (?, ?, ?)");
  $type = 'service_faq';
  $stmt->bind_param("sss", $type, $content, $chatId);
  $stmt->execute();
  $stmt->close();
  updateUserState($chatId, null);
  sendMessage($chatId, 'محتوای بخش سوالات متداول با موفقیت ذخیره شد.');
  sendTicketingAdminMenu($chatId);
}


// --- توابع نمایش محتوا ---
function sendLotteryContent($chatId, $type) {
  global $conn;
  $text = "محتوای مورد نظر در دسترس نیست. لطفاً با ادمین تماس بگیرید.";
  $stmt = $conn->prepare("SELECT content FROM lotteries WHERE type = ? ORDER BY created_at DESC LIMIT 1");
  $stmt->bind_param("s", $type);
  $stmt->execute();
  $result = $stmt->get_result();
  if ($row = $result->fetch_assoc()) {
    $text = $row['content'];
  }
  $stmt->close();
  sendMessage($chatId, $text, buildKeyboard([['🎁 قرعه‌کشی‌ها'], ['منوی اصلی']]));
}

function sendSeminarContent($chatId, $type) {
  global $conn;
  $text = "محتوای مورد نظر در دسترس نیست. لطفاً با ادمین تماس بگیرید.";
  $stmt = $conn->prepare("SELECT content FROM seminars WHERE type = ? ORDER BY created_at DESC LIMIT 1");
  $stmt->bind_param("s", $type);
  $stmt->execute();
  $result = $stmt->get_result();
  if ($row = $result->fetch_assoc()) {
    $text = $row['content'];
  }
  $stmt->close();
  sendMessage($chatId, $text, buildKeyboard([['🎓 رویدادهای فالنیک'], ['منوی اصلی']])); // دکمه بازگشت اصلاح شد
}

function sendAboutUs($chatId) {
  global $conn;
  $text = "محتوای مورد نظر در دسترس نیست. لطفاً با ادمین تماس بگیرید.";
  $stmt = $conn->prepare("SELECT content FROM static_contents WHERE type = 'about_us' ORDER BY created_at DESC LIMIT 1");
  $stmt->execute();
  $result = $stmt->get_result();
  if ($row = $result->fetch_assoc()) {
    $text = $row['content'];
  }
  $stmt->close();
  sendMessage($chatId, $text, buildKeyboard([['منوی اصلی']]));
}

function sendContactInfo($chatId) {
  global $conn;
  $text = "محتوای مورد نظر در دسترس نیست. لطفاً با ادمین تماس بگیرید.";
  $stmt = $conn->prepare("SELECT content FROM static_contents WHERE type = 'contact_info' ORDER BY created_at DESC LIMIT 1");
  $stmt->execute();
  $result = $stmt->get_result();
  if ($row = $result->fetch_assoc()) {
    $text = $row['content'];
  }
  $stmt->close();
  sendMessage($chatId, $text, buildKeyboard([['منوی اصلی']]));
}

// --- توابع منوهای کاربر ---
function sendMainMenu($chatId) {
  $keyboard = buildKeyboard([
    ['🎓 رویدادهای فالنیک'], // تغییر نام و انتقال به بالا
    ['💬 چت مستقیم با کارشناسان'], // دکمه جدید اضافه شد
    ['🎁 قرعه‌کشی‌ها'],
    ['🎫 پشتیبانی مشتریان'],
    ['ℹ️ درباره فالنیک', '📞 اطلاعات تماس']
  ]);
  sendMessage($chatId, 'به منوی اصلی خوش آمدید.', $keyboard);
}

function sendGiveawaysMenu($chatId) {
  $keyboard = buildKeyboard([
    ['📣 قرعه‌کشی فعلی', '📝 نحوه شرکت'],
    ['🏆 نتایج دوره قبل', '❓ سوالات متداول قرعه‌کشی'],
    ['📤 دعوت از دوستان'],
    ['منوی اصلی']
  ]);
  sendMessage($chatId, 'لطفاً یکی از گزینه‌ها را انتخاب کنید.', $keyboard);
}

// --- توابع منوی رویدادها (جدید) ---
function sendEventsMenu($chatId) {
  $keyboard = buildKeyboard([
    ['رویداد Nextnode-sijourney', 'آرشیو رویدادها'],
    ['منوی اصلی']
  ]);
  sendMessage($chatId, 'لطفاً یکی از گزینه‌ها را انتخاب کنید.', $keyboard);
}

function sendNextnodeMenu($chatId) {
  $keyboard = buildKeyboard([
    ['لیست وبینارها و سرفصل ها', 'لیست اساتید'],
    ['اخبار رویداد', 'لینک دعوت برای ثبت نام رویداد'],
    ['🎓 رویدادهای فالنیک'] // دکمه بازگشت
  ]);
  sendMessage($chatId, 'اطلاعات رویداد Nextnode-sijourney:', $keyboard);
}

function sendArchiveMenu($chatId) {
  $keyboard = buildKeyboard([
    ['رویدادهای حضوری', 'رویدادهای آنلاین'],
    ['🎓 رویدادهای فالنیک'] // دکمه بازگشت
  ]);
  sendMessage($chatId, 'آرشیو رویدادها:', $keyboard);
}
// --- پایان توابع منوی رویدادها ---

function sendTicketingMenu($chatId) {
  $keyboard = buildKeyboard([
    ['📝 ثبت تیکت جدید'],
    ['❓ سوالات متداول'],
    ['منوی اصلی']
  ]);
  sendMessage($chatId, 'لطفاً یکی از گزینه‌ها را انتخاب کنید.', $keyboard);
}

function sendNewTicketInfo($chatId) {
  global $conn;
  $text = "محتوای مورد نظر در دسترس نیست. لطفاً با ادمین تماس بگیرید.";
  $stmt = $conn->prepare("SELECT content FROM static_contents WHERE type = 'new_ticket_info' ORDER BY created_at DESC LIMIT 1");
  $stmt->execute();
  $result = $stmt->get_result();
  if ($row = $result->fetch_assoc()) {
    $text = $row['content'];
  }
  $stmt->close();
  sendMessage($chatId, $text, buildKeyboard([['🎫 پشتیبانی مشتریان'], ['منوی اصلی']]));
}

function sendServiceFAQ($chatId) {
  global $conn;
  $text = "محتوای مورد نظر در دسترس نیست. لطفاً با ادمین تماس بگیرید.";
  $stmt = $conn->prepare("SELECT content FROM static_contents WHERE type = 'service_faq' ORDER BY created_at DESC LIMIT 1");
  $stmt->execute();
  $result = $stmt->get_result();
  if ($row = $result->fetch_assoc()) {
    $text = $row['content'];
  }
  $stmt->close();
  sendMessage($chatId, $text, buildKeyboard([['🎫 پشتیبانی مشتریان'], ['منوی اصلی']]));
}

// توابع زیر حذف شده‌اند
function sendPreviousTickets($chatId) {
  sendMessage($chatId, 'این گزینه دیگر در دسترس نیست.');
}

function sendQuickHelp($chatId) {
  sendMessage($chatId, 'این گزینه دیگر در دسترس نیست.');
}

function performBroadcast($adminId, $messageText) {
  global $conn;
  
  set_time_limit(0); 
  
  $sql = "SELECT id FROM users";
  $result = $conn->query($sql);
  
  $success_count = 0;
  $failed_count = 0;
  
  sendMessage($adminId, "⏳ در حال ارسال پیام... (ممکن است کمی طول بکشد)");

  if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
      $userId = $row['id'];
      
      // اینجا چک می‌کنیم ارسال موفق بود یا نه
      if (sendMessage($userId, $messageText)) {
          $success_count++;
      } else {
          $failed_count++; // مثلا کاربر ربات را بلاک کرده است
      }
      
      // یک وقفه بسیار کوتاه برای جلوگیری از فشار به سرور تلگرام (اختیاری)
      usleep(50000); // 0.05 ثانیه
    }
  }
  
  updateUserState($adminId, null);
  
  // گزارش دقیق به ادمین
  $report = "📊 **گزارش ارسال پیام همگانی:**\n\n";
  $report .= "✅ ارسال موفق: $success_count نفر\n";
  $report .= "❌ ارسال ناموفق (احتمالا بلاک): $failed_count نفر\n";
  $report .= "📝 مجموع تلاش‌ها: " . ($success_count + $failed_count);
  
  sendMessage($adminId, $report);
  sendAdminMenu($adminId);
}

function exportUsersList($chatId) {
  global $conn;
  global $apiUrl; // دسترسی به متغیر آدرس API

  sendMessage($chatId, "⏳ در حال آماده‌سازی فایل لیست کاربران...");

  $filename = "users_list_" . date("Y-m-d_H-i") . ".csv";
  $filepath = sys_get_temp_dir() . "/" . $filename; // ذخیره موقت در پوشه تمپ سرور

  $fp = fopen($filepath, 'w');
  
  // اضافه کردن هدر (عنوان ستون‌ها) به فایل، BOM برای نمایش صحیح فارسی در اکسل
  fputs($fp, $bom =( chr(0xEF) . chr(0xBB) . chr(0xBF) ));
  fputcsv($fp, ['User ID', 'Name', 'Username', 'Join Date']);

  $sql = "SELECT id, first_name, username, created_at FROM users";
  $result = $conn->query($sql);

  if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
      // اگر created_at هنوز پر نشده (برای کاربران قدیمی)، خط تیره بگذار
      $date = $row['created_at'] ? $row['created_at'] : "-";
      fputcsv($fp, [$row['id'], $row['first_name'], '@' . $row['username'], $date]);
    }
  }
  fclose($fp);

  // ارسال فایل به تلگرام با CURL (چون sendDocument با file_get_contents ساده سخت است)
  $url = $apiUrl . "sendDocument";
  $post_fields = [
    'chat_id'   => $chatId,
    'document'  => new CURLFile($filepath),
    'caption'   => "📂 لیست کامل کاربران ربات\n📅 تاریخ: " . date("Y/m/d")
  ];

  $ch = curl_init(); 
  curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type:multipart/form-data"));
  curl_setopt($ch, CURLOPT_URL, $url); 
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
  curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields); 
  $output = curl_exec($ch);
  curl_close($ch);

  // حذف فایل موقت از سرور
  unlink($filepath);
}
?>